<?php
session_start();

// If no success message, redirect to registration page
if (!isset($_SESSION['success'])) {
    header('Location: register.php');
    exit;
}

$accountNumber = $_SESSION['account_number'];
$email = $_SESSION['registered_email'];
$emailSent = $_SESSION['email_sent'] ?? true; // Default to true if not set

// Clear the session variables
unset($_SESSION['success']);
unset($_SESSION['account_number']);
unset($_SESSION['registered_email']);
unset($_SESSION['email_sent']);
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Registration Successful - First National Bank Incorporated</title>
    
    <!-- CSS Dependencies -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/boxicons@2.0.7/css/boxicons.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@400;500;600&display=swap" rel="stylesheet">

    <style>
        body {
            font-family: 'Poppins', sans-serif;
            background: linear-gradient(135deg, #2563eb, #1e40af);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 1.5rem;
        }

        .success-container {
            background: white;
            border-radius: 20px;
            padding: 3rem 2rem;
            text-align: center;
            max-width: 500px;
            width: 90%;
            box-shadow: 0 20px 40px rgba(0,0,0,0.1);
        }

        .success-icon {
            width: 80px;
            height: 80px;
            background: #059669;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 2rem;
            color: white;
            font-size: 2.5rem;
        }

        .account-number {
            background: #f8fafc;
            padding: 1rem;
            border-radius: 10px;
            margin: 1.5rem 0;
            font-size: 1.25rem;
            font-weight: 600;
            color: #1e40af;
        }

        .btn-primary {
            background: #2563eb;
            border: none;
            padding: 0.75rem 2rem;
            border-radius: 10px;
            font-weight: 500;
            transition: all 0.3s ease;
        }

        .btn-primary:hover {
            background: #1e40af;
            transform: translateY(-2px);
        }

        .alert {
            border-radius: 10px;
            padding: 1rem;
            margin: 1.5rem 0;
        }

        .alert-warning {
            background-color: #fffbeb;
            border-left: 4px solid #f59e0b;
            color: #92400e;
        }

        .steps {
            margin: 1.5rem 0;
            text-align: left;
        }

        .step {
            display: flex;
            align-items: flex-start;
            margin-bottom: 1rem;
        }

        .step-number {
            width: 24px;
            height: 24px;
            background: #2563eb;
            border-radius: 50%;
            display: flex;
            align-items: center;
            justify-content: center;
            color: white;
            font-weight: bold;
            margin-right: 0.75rem;
            flex-shrink: 0;
            font-size: 0.8rem;
        }

        .step-content {
            flex: 1;
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(20px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .success-container {
            animation: fadeIn 0.5s ease-out;
        }
    </style>
</head>
<body>
    <div class="success-container">
        <div class="success-icon">
            <i class='bx bx-check'></i>
        </div>
        
        <h2 class="mb-3">Registration Successful!</h2>
        <p class="text-muted mb-4">Your account has been created successfully.</p>

        <div class="account-number">
            Account Number: <?php echo htmlspecialchars($accountNumber); ?>
        </div>

        <?php if ($emailSent): ?>
            <p class="mb-3">
                We've sent a verification email to:<br>
                <strong><?php echo htmlspecialchars($email); ?></strong>
            </p>
            
            <div class="steps">
                <div class="step">
                    <div class="step-number">1</div>
                    <div class="step-content">
                        <strong>Check your email</strong> and click the verification link
                    </div>
                </div>
                <div class="step">
                    <div class="step-number">2</div>
                    <div class="step-content">
                        <strong>Verify your account</strong> to activate all features
                    </div>
                </div>
                <div class="step">
                    <div class="step-number">3</div>
                    <div class="step-content">
                        <strong>Log in</strong> to access your new banking account
                    </div>
                </div>
            </div>
            
            <p class="text-muted mb-4">
                Please check your inbox and spam folder for the verification email.
            </p>
        <?php else: ?>
            <div class="alert alert-warning">
                <i class='bx bx-error-circle me-2'></i>
                <strong>Verification email could not be sent</strong>
                <p class="mb-0 mt-2">We couldn't send a verification email to <strong><?php echo htmlspecialchars($email); ?></strong>. Please contact our support team to verify your account.</p>
            </div>
            
            <p class="text-muted mb-4">
                You can still log in, but some features may be limited until your email is verified.
            </p>
        <?php endif; ?>

        <div class="d-grid gap-2">
            <a href="login.php" class="btn btn-primary">
                Continue to Login <i class='bx bx-right-arrow-alt'></i>
            </a>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/698919832510d91c3c5b9ece/1jgvonb1o';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
</body>
</html>
