<?php
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

/**
 * Send email using SMTP via PHPMailer
 * 
 * @param string $to Recipient email
 * @param string $subject Email subject
 * @param string $body Email HTML body
 * @param string $fromName Sender name (optional)
 * @param string $fromEmail Sender email (optional)
 * @return bool Success status
 */
function sendSMTPEmail($to, $subject, $body, $fromName = null, $fromEmail = null) {
    // Load PHPMailer from vendor directory
    require_once __DIR__ . '/../vendor/autoload.php';
    
    // Default values
    $bankName = defined('BANK_NAME') ? BANK_NAME : 'First National Bank Incorporated';
    $fromName = $fromName ?? (defined('MAIL_FROM_NAME') ? MAIL_FROM_NAME : $bankName);
    $fromEmail = $fromEmail ?? (defined('MAIL_FROM_ADDRESS') ? MAIL_FROM_ADDRESS : 'noreply@yourdomain.com');
    
    // SMTP Configuration
    $smtpHost = defined('SMTP_HOST') ? SMTP_HOST : 'localhost';
    $smtpPort = defined('SMTP_PORT') ? SMTP_PORT : 25;
    $smtpUsername = defined('SMTP_USERNAME') ? SMTP_USERNAME : '';
    $smtpPassword = defined('SMTP_PASSWORD') ? SMTP_PASSWORD : '';
    $smtpSecure = defined('SMTP_SECURE') ? SMTP_SECURE : '';
    
    // Create a new PHPMailer instance
    $mail = new PHPMailer(true);
    
    try {
        // Server settings
        $mail->SMTPDebug = 0;                      // Disable debug output
        $mail->isSMTP();                           // Send using SMTP
        $mail->Host       = $smtpHost;             // SMTP server
        $mail->SMTPAuth   = !empty($smtpUsername); // Enable SMTP authentication if username is provided
        
        if (!empty($smtpUsername)) {
            $mail->Username   = $smtpUsername;     // SMTP username
            $mail->Password   = $smtpPassword;     // SMTP password
        }
        
        if (!empty($smtpSecure)) {
            $mail->SMTPSecure = $smtpSecure;       // Enable TLS/SSL encryption
        }
        
        $mail->Port       = $smtpPort;             // TCP port to connect to
        
        // Add SSL options to avoid certificate verification issues
        $mail->SMTPOptions = [
            'ssl' => [
                'verify_peer' => false,
                'verify_peer_name' => false,
                'allow_self_signed' => true
            ]
        ];
        
        // Recipients
        $mail->setFrom($fromEmail, $fromName);
        $mail->addAddress($to);                    // Add a recipient
        
        // Content
        $mail->isHTML(true);                       // Set email format to HTML
        $mail->Subject = $subject;
        $mail->Body    = $body;
        $mail->CharSet = 'UTF-8';                  // Set character encoding
        
        // Send the email
        $result = $mail->send();
        error_log("Email sent successfully to: $to");
        return $result;
    } catch (Exception $e) {
        error_log("Email sending failed. Mailer Error: {$mail->ErrorInfo}");
        return false;
    }
}
?>
