<?php
session_start();
require_once 'includes/auth_check.php';

$page = 'transfer';
$database = new Database();
$db = $database->getConnection();

// Get transaction ID from URL
$transactionId = $_GET['id'] ?? '';

// If no transaction ID, redirect to dashboard
if (empty($transactionId)) {
    header('Location: dashboard.php');
    exit;
}

// Get transaction details - Updated to handle transaction IDs with suffixes
$stmt = $db->prepare("
    SELECT t.*, 
           u.first_name as sender_first_name, u.last_name as sender_last_name, u.account_number as sender_account,
           r.first_name as recipient_first_name, r.last_name as recipient_last_name, r.account_number as recipient_account,
           u.currency
    FROM transactions t
    JOIN users u ON t.user_id = u.id
    LEFT JOIN users r ON t.recipient_id = r.id
    WHERE t.reference = ? AND t.user_id = ?
");
$stmt->execute([$transactionId, $_SESSION['user_id']]);
$transaction = $stmt->fetch(PDO::FETCH_ASSOC);

// If transaction not found, redirect to dashboard
if (!$transaction) {
    header('Location: dashboard.php');
    exit;
}

include 'includes/header.php';
include 'includes/sidebar.php';
?>

<style>
    .success-icon {
        width: 80px;
        height: 80px;
        background-color: #10b981;
        border-radius: 50%;
        display: flex;
        align-items: center;
        justify-content: center;
        margin: 0 auto 1.5rem;
        color: white;
        font-size: 40px;
    }
    
    .transaction-details {
        background-color: #f9fafb;
        border-radius: 0.75rem;
        padding: 1.5rem;
    }
    
    .detail-row {
        display: flex;
        justify-content: space-between;
        padding: 0.75rem 0;
        border-bottom: 1px solid #e5e7eb;
    }
    
    .detail-row:last-child {
        border-bottom: none;
    }
    
    .detail-label {
        color: #6b7280;
        font-weight: 500;
    }
    
    .detail-value {
        font-weight: 600;
        text-align: right;
    }
</style>

<div class="main-content">
    <div class="container py-4">
        <div class="row justify-content-center">
            <div class="col-lg-8">
                <div class="card">
                    <div class="card-body p-4 text-center">
                        <div class="success-icon">
                            <i class='bx bx-check'></i>
                        </div>
                        
                        <h2 class="mb-3">Transfer Successful!</h2>
                        
                        <p class="text-muted mb-4">Your money has been transferred successfully.</p>
                        
                        <div class="transaction-details mb-4">
                            <div class="detail-row">
                                <div class="detail-label">Transaction ID</div>
                                <div class="detail-value"><?php echo htmlspecialchars($transactionId); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Date & Time</div>
                                <div class="detail-value"><?php echo date('M j, Y g:i A', strtotime($transaction['created_at'])); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Amount</div>
                                <div class="detail-value"><?php echo htmlspecialchars($transaction['currency']); ?> <?php echo number_format(abs($transaction['amount']), 2); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Recipient</div>
                                <div class="detail-value"><?php echo htmlspecialchars($transaction['recipient_first_name'] . ' ' . $transaction['recipient_last_name']); ?></div>
                            </div>
                            <div class="detail-row">
                                <div class="detail-label">Account Number</div>
                                <div class="detail-value"><?php echo htmlspecialchars($transaction['recipient_account']); ?></div>
                            </div>
                            <?php if (!empty($transaction['description'])): ?>
                            <div class="detail-row">
                                <div class="detail-label">Description</div>
                                <div class="detail-value"><?php echo htmlspecialchars($transaction['description']); ?></div>
                            </div>
                            <?php endif; ?>
                        </div>
                        
                        <div class="d-flex justify-content-center gap-3">
                            <a href="dashboard.php" class="btn btn-primary">Back to Dashboard</a>
                            <a href="transfer.php" class="btn btn-outline-primary">Make Another Transfer</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
