<?php
session_start();
require_once 'includes/auth_check.php';

header('Content-Type: application/json');

$database = new Database();
$db = $database->getConnection();

$account_number = trim($_GET['account'] ?? '');

if (empty($account_number)) {
    echo json_encode(['success' => false, 'message' => 'No account number provided']);
    exit;
}

try {
    // Search for the account, excluding the current user
    $stmt = $db->prepare("SELECT id, first_name, last_name, account_number FROM users WHERE account_number = ? AND id != ? AND status = 'active'");
    $stmt->execute([$account_number, $_SESSION['user_id']]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($user) {
        // Found the user
        echo json_encode([
            'success' => true,
            'user' => [
                'id' => $user['id'],
                'first_name' => $user['first_name'],
                'last_name' => $user['last_name'],
                'account_number' => $user['account_number']
            ]
        ]);
    } else {
        // No user found
        echo json_encode(['success' => false, 'message' => 'No user found with this account number']);
    }
} catch (PDOException $e) {
    echo json_encode(['success' => false, 'message' => 'Database error']);
    error_log("Search Account Error: " . $e->getMessage());
}
?>
