<?php
session_start();
require_once 'includes/auth_check.php';
require_once 'config/database.php';
require_once 'includes/notification_functions.php';

// Redirect if not logged in
if (!isset($_SESSION['user_id'])) {
    header('Location: login.php');
    exit();
}

$database = new Database();
$db = $database->getConnection();

// Mark all notifications as read
markAllNotificationsAsRead($db, $_SESSION['user_id']);

// Redirect back to referring page or dashboard
$redirect = $_SERVER['HTTP_REFERER'] ?? 'dashboard.php';
header("Location: $redirect");
exit();
?>
