<?php
// The $user variable and BASE_URL constant are available from auth_check.php
?>
<div class="sidebar" id="sidebar">
    <!-- Sidebar Header with Logo -->
    <div class="sidebar-header">
        <a href="<?php echo BASE_URL; ?>customer/dashboard.php" class="sidebar-logo">
           
            <span><img src="../assets/images/logo_c.png"></span>
        </a>
    </div>

    <!-- Main Menu -->
    <div class="sidebar-menu">
        <div class="menu-section">
            <div class="menu-title">Menu</div>
            <a href="<?php echo BASE_URL; ?>customer/dashboard.php" class="menu-item <?php echo ($page == 'dashboard') ? 'active' : ''; ?>">
                <i class='bx bxs-dashboard'></i><span>Dashboard</span>
            </a>
        </div>

        <div class="menu-section">
            <div class="menu-title">Transactions</div>
            <div class="menu-dropdown">
                <a href="#transferDropdown" class="menu-item dropdown-toggle <?php echo (in_array($page, ['transfer', 'international-transfer', 'beneficiaries'])) ? 'active' : ''; ?>" data-bs-toggle="collapse" aria-expanded="<?php echo (in_array($page, ['transfer', 'international-transfer', 'beneficiaries'])) ? 'true' : 'false'; ?>">
                    <i class='bx bx-transfer'></i><span>Transfer</span><i class='bx bx-chevron-down ms-auto'></i>
                </a>
                <div class="collapse <?php echo (in_array($page, ['transfer', 'international-transfer', 'beneficiaries'])) ? 'show' : ''; ?>" id="transferDropdown">
                    <a href="<?php echo BASE_URL; ?>customer/transfer.php" class="submenu-item <?php echo ($page == 'transfer') ? 'active' : ''; ?>"><span>Inter Bank</span></a>
                    <a href="<?php echo BASE_URL; ?>customer/international-transfer.php" class="submenu-item <?php echo ($page == 'international-transfer') ? 'active' : ''; ?>"><span>Wire Transfer</span></a>
                    <a href="<?php echo BASE_URL; ?>customer/beneficiaries.php" class="submenu-item <?php echo ($page == 'beneficiaries') ? 'active' : ''; ?>"><span>Beneficiaries</span></a>
                </div>
            </div>
            
            <!-- Deposit Menu Item -->
            <a href="<?php echo BASE_URL; ?>customer/deposit.php" class="menu-item <?php echo ($page == 'deposit') ? 'active' : ''; ?>">
                <i class='bx bx-wallet'></i><span>Deposit</span>
            </a>

            <a href="<?php echo BASE_URL; ?>customer/transactions.php" class="menu-item <?php echo ($page == 'transactions') ? 'active' : ''; ?>">
                <i class='bx bx-history'></i><span>History</span>
            </a>
        </div>

        <div class="menu-section">
            <div class="menu-title">Account</div>
            <a href="<?php echo BASE_URL; ?>customer/profile.php" class="menu-item <?php echo ($page == 'profile') ? 'active' : ''; ?>">
                <i class='bx bx-user-circle'></i><span>Profile</span>
            </a>
            <a href="<?php echo BASE_URL; ?>customer/cards.php" class="menu-item <?php echo ($page == 'cards') ? 'active' : ''; ?>">
                <i class='bx bx-credit-card'></i><span>My Cards</span>
            </a>
            <a href="<?php echo BASE_URL; ?>customer/loans.php" class="menu-item <?php echo ($page == 'loans') ? 'active' : ''; ?>">
                <i class='bx bx-money'></i><span>My Loans</span>
            </a>
            <a href="<?php echo BASE_URL; ?>customer/tickets.php" class="menu-item <?php echo ($page == 'tickets') ? 'active' : ''; ?>">
                <i class='bx bx-support'></i><span>Support Tickets</span>
            </a>
            <a href="<?php echo BASE_URL; ?>customer/settings.php" class="menu-item <?php echo ($page == 'settings') ? 'active' : ''; ?>">
                <i class='bx bx-cog'></i><span>Settings</span>
            </a>
        </div>
    </div>

    <!-- Sidebar Footer with Logout -->
    <div class="sidebar-footer">
        <a href="<?php echo BASE_URL; ?>logout.php" class="menu-item logout-btn">
            <i class='bx bx-log-out'></i><span>Logout</span>
        </a>
    </div>
</div>

<div class="sidebar-overlay" id="sidebarOverlay"></div>

<style>
/* Simplified & Enhanced Sidebar Styles */
:root {
    --sidebar-width: 260px;
    --primary-color: #4f46e5;
    --primary-light: #eef2ff;
    --danger-color: #ef4444;
    --danger-light: #fef2f2;
    --text-dark: #1e293b;
    --text-light: #64748b;
    --border-color: #e2e8f0;
}
.sidebar {
    position: fixed; left: 0; top: 0; bottom: 0;
    width: var(--sidebar-width);
    background: white;
    box-shadow: 0 0 25px rgba(0,0,0,0.05);
    z-index: 1050;
    transition: transform 0.3s ease-in-out;
    display: flex; flex-direction: column;
}
.sidebar-header {
    padding: 1.25rem 1.5rem;
    border-bottom: 1px solid var(--border-color);
    flex-shrink: 0;
}
.sidebar-logo {
    display: flex; align-items: center;
    text-decoration: none; color: var(--text-dark);
    font-size: 1.5rem; font-weight: 700;
}
.sidebar-logo i { color: var(--primary-color); margin-right: 0.5rem; }

.sidebar-menu { flex-grow: 1; overflow-y: auto; padding: 1rem 0; }
.menu-title {
    padding: 0.5rem 1.5rem; font-size: 0.75rem;
    text-transform: uppercase; color: var(--text-light);
    font-weight: 600; letter-spacing: 0.05em;
}
.menu-item {
    padding: 0.85rem 1.5rem; margin: 0.25rem 0.75rem;
    display: flex; align-items: center;
    color: var(--text-light); text-decoration: none;
    transition: all 0.2s ease; border-radius: 0.5rem;
}
.menu-item:hover { background: var(--primary-light); color: var(--primary-color); }
.menu-item.active { background: var(--primary-color); color: white; font-weight: 500; }
.menu-item i { margin-right: 1rem; font-size: 1.25rem; }
.dropdown-toggle .bx-chevron-down { transition: transform 0.3s ease; }
.dropdown-toggle[aria-expanded="true"] .bx-chevron-down { transform: rotate(180deg); }
.submenu-item {
    padding: 0.6rem 1.5rem 0.6rem 4rem;
    display: flex; align-items: center;
    color: var(--text-light); text-decoration: none;
    font-size: 0.9rem; position: relative;
}
.submenu-item::before {
    content: ''; position: absolute; left: 2.5rem; top: 50%;
    transform: translateY(-50%); width: 4px; height: 4px;
    background-color: #cbd5e1; border-radius: 50%;
}
.submenu-item:hover, .submenu-item.active { color: var(--primary-color); font-weight: 500; }
.submenu-item.active::before { background-color: var(--primary-color); }

.sidebar-footer { padding: 0 0.75rem 1rem; border-top: 1px solid var(--border-color); flex-shrink: 0; }
.logout-btn { margin-top: 1rem; }
.logout-btn:hover { background-color: var(--danger-light); color: var(--danger-color); }

.sidebar-overlay { display: none; position: fixed; inset: 0; background: rgba(0,0,0,0.5); z-index: 1040; opacity: 0; transition: opacity 0.3s ease; }
.sidebar-overlay.show { display: block; opacity: 1; }

@media (max-width: 992px) {
    .sidebar { transform: translateX(-100%); }
    .sidebar.show { transform: translateX(0); }
}
</style>

<script>
// --- MOBILE SIDEBAR TOGGLE LOGIC ---
document.addEventListener('DOMContentLoaded', function() {
    const sidebar = document.getElementById('sidebar');
    const overlay = document.getElementById('sidebarOverlay');
    const toggler = document.getElementById('sidebarToggler'); // This ID must exist in your header

    if (toggler) {
        toggler.addEventListener('click', function() {
            sidebar.classList.toggle('show');
            overlay.classList.toggle('show');
        });
    }
    if (overlay) {
        overlay.addEventListener('click', function() {
            sidebar.classList.remove('show');
            overlay.classList.remove('show');
        });
    }
});
</script>
