<?php
session_start();
include_once '../config/database.php';

header('Content-Type: application/json');

try {
    $database = new Database();
    $db = $database->getConnection();

    $accountNumber = $_POST['accountNumber'] ?? '';

    if (empty($accountNumber)) {
        throw new Exception("Account number is required");
    }

    // Simulate account verification
    $stmt = $db->prepare("SELECT id, first_name, last_name FROM users WHERE account_number = ?");
    $stmt->execute([$accountNumber]);
    $user = $stmt->fetch(PDO::FETCH_ASSOC);

    if ($user) {
        echo json_encode([
            'success' => true,
            'id' => $user['id'],
            'name' => $user['first_name'] . ' ' . $user['last_name']
        ]);
    } else {
        echo json_encode([
            'success' => false,
            'message' => 'Account not found'
        ]);
    }
    exit;

} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
    exit;
}
