<?php
session_start();
require_once '../../config/database.php';
require_once '../includes/auth_check.php';

if (!isset($_GET['id'])) {
    echo json_encode(['success' => false, 'message' => 'Deposit ID is required.']);
    exit();
}

$deposit_id = $_GET['id'];
$database = new Database();
$db = $database->getConnection();

try {
    // Get deposit details
    $stmt = $db->prepare("SELECT * FROM crypto_deposits WHERE id = ? AND user_id = ?");
    $stmt->execute([$deposit_id, $_SESSION['user_id']]);
    $deposit = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if (!$deposit) {
        echo json_encode(['success' => false, 'message' => 'Deposit not found or you do not have permission to view it.']);
        exit();
    }
    
    echo json_encode(['success' => true, 'deposit' => $deposit]);
} catch (Exception $e) {
    echo json_encode(['success' => false, 'message' => 'An error occurred: ' . $e->getMessage()]);
}
