<?php
// Include database connection
require_once 'config/database.php';

// Get the token from the URL
$token = $_GET['token'] ?? '';

echo "<h1>PIN Reset Token Check</h1>";

if (empty($token)) {
    echo "<p>No token provided</p>";
    exit;
}

echo "<p>Checking token: " . htmlspecialchars(substr($token, 0, 10)) . "...</p>";

try {
    $database = new Database();
    $db = $database->getConnection();
    
    // First, check if the token exists at all
    $stmt = $db->prepare("SELECT * FROM pin_reset_tokens WHERE token = ?");
    $stmt->execute([$token]);
    $reset = $stmt->fetch(PDO::FETCH_ASSOC);
    
    if ($reset) {
        echo "<p style='color:green'>Token found in database!</p>";
        
        // Check if token is expired
        $expires = new DateTime($reset['expires_at']);
        $now = new DateTime();
        
        echo "<p>Token expires at: " . $expires->format('Y-m-d H:i:s') . "</p>";
        echo "<p>Current time: " . $now->format('Y-m-d H:i:s') . "</p>";
        
        if ($expires > $now) {
            echo "<p style='color:green'>Token is still valid!</p>";
        } else {
            echo "<p style='color:red'>Token has expired.</p>";
        }
        
        // Get user information
        $stmt = $db->prepare("SELECT email, first_name, last_name FROM users WHERE id = ?");
        $stmt->execute([$reset['user_id']]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        
        if ($user) {
            echo "<p>Associated user: " . htmlspecialchars($user['email']) . " (" . 
                htmlspecialchars($user['first_name'] . ' ' . $user['last_name']) . ")</p>";
        }
        
        // Show token details
        echo "<h2>Token Details:</h2>";
        echo "<pre>";
        print_r($reset);
        echo "</pre>";
        
        // Generate test links
        $email = $user['email'] ?? '';
        $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
        $host = $_SERVER['HTTP_HOST'];
        
        echo "<h2>Test Links:</h2>";
        echo "<p><a href='$protocol://$host/reset-pin.php?token=$token'>Link without email</a></p>";
        echo "<p><a href='$protocol://$host/reset-pin.php?email=" . urlencode($email) . "&token=$token'>Link with email</a></p>";
        
    } else {
        echo "<p style='color:red'>Token not found in database.</p>";
        
        // Check if any tokens exist
        $stmt = $db->query("SELECT COUNT(*) FROM pin_reset_tokens");
        $count = $stmt->fetchColumn();
        
        echo "<p>Total tokens in database: $count</p>";
        
        if ($count > 0) {
            echo "<h2>Sample tokens:</h2>";
            $stmt = $db->query("SELECT * FROM pin_reset_tokens ORDER BY created_at DESC LIMIT 5");
            $tokens = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            foreach ($tokens as $t) {
                echo "<p>Token: " . substr($t['token'], 0, 10) . "...</p>";
                echo "<p>User ID: " . $t['user_id'] . "</p>";
                echo "<p>Expires: " . $t['expires_at'] . "</p>";
                echo "<hr>";
            }
        }
    }
    
} catch (Exception $e) {
    echo "<p style='color:red'>Error: " . htmlspecialchars($e->getMessage()) . "</p>";
}
?>
