<?php
// This file is located in admin/includes/
header("Content-type: text/css; charset: UTF-8");

// Default colors in case the database connection fails
$primaryColor = '#4f46e5';
$sidebarBg = '#111827';
$sidebarText = '#ffffff';

try {
    // Corrected Path: Go up two levels to the root directory
    require_once __DIR__ . '/../../config/database.php';
    require_once __DIR__ . '/../../includes/functions.php';

    $database = new Database();
    $db = $database->getConnection();

    // Fetch all theme-related settings in one query
    $stmt = $db->query("SELECT setting_name, setting_value FROM settings WHERE setting_name LIKE 'theme_%'");
    $settings = $stmt->fetchAll(PDO::FETCH_KEY_PAIR);

    // Assign colors from database, using defaults if a setting is missing
    $primaryColor = $settings['theme_primary_color'] ?? $primaryColor;
    $sidebarBg = $settings['theme_sidebar_bg'] ?? $sidebarBg;
    $sidebarText = $settings['theme_sidebar_text'] ?? $sidebarText;

} catch (Exception $e) {
    // If there's any error, we just use the default colors.
    error_log("theme.css.php Error: " . $e->getMessage());
}

// --- Generate the CSS ---
?>
:root {
    --primary-color: <?php echo htmlspecialchars($primaryColor); ?>;
    --sidebar-bg: <?php echo htmlspecialchars($sidebarBg); ?>;
    --sidebar-text-color: <?php echo htmlspecialchars($sidebarText); ?>;
    --sidebar-hover-bg: rgba(255, 255, 255, 0.1);
    --sidebar-active-bg: <?php echo htmlspecialchars($primaryColor); ?>;
}

/* Apply theme to Bootstrap components */
.btn-primary { background-color: var(--primary-color); border-color: var(--primary-color); }
.btn-primary:hover { opacity: 0.9; background-color: var(--primary-color); border-color: var(--primary-color); }
a, .text-primary, .page-item.active .page-link { color: var(--primary-color); }
.page-link { color: var(--primary-color); }

/* Apply theme to Admin Sidebar */
ul.navbar-nav.bg-gradient-primary { background-color: var(--sidebar-bg) !important; background-image: none !important; }
.sidebar-dark .nav-item .nav-link { color: var(--sidebar-text-color); }
.sidebar-dark .nav-item.active .nav-link { color: var(--sidebar-text-color); background-color: var(--sidebar-active-bg); }
.sidebar-dark .nav-item .nav-link:hover { background-color: var(--sidebar-hover-bg); }
.sidebar-dark .nav-item .nav-link i { color: var(--sidebar-text-color); opacity: 0.7; }
.sidebar-dark .nav-item.active .nav-link i, .sidebar-dark .nav-item .nav-link:hover i { opacity: 1; }

/* Apply theme to Customer Sidebar (if you have one with this class) */
.customer-sidebar { background-color: var(--sidebar-bg); }
.customer-sidebar .nav-link { color: var(--sidebar-text-color); }
.customer-sidebar .nav-link.active { background-color: var(--sidebar-active-bg); }
