<?php
require_once 'includes/auth_check.php';
// *** MODIFICATION: Set the current page for the sidebar active state ***
$page = 'btc';
require_once '../config/database.php';
require_once '../includes/functions.php';

$database = new Database();
$db = $database->getConnection();

try {
    // *** MODIFICATION: Changed the WHERE clause to filter for BTC currency ***
    $query = "SELECT t.*, u.first_name, u.last_name FROM transactions t JOIN users u ON t.user_id = u.id WHERE t.currency = 'BTC'";
    $params = [];

    // Date Range Filtering (works on top of the base filter)
    $start_date = $_GET['start_date'] ?? '';
    $end_date = $_GET['end_date'] ?? '';

    if (!empty($start_date)) {
        $query .= " AND t.created_at >= :start_date";
        $params[':start_date'] = $start_date . ' 00:00:00';
    }
    if (!empty($end_date)) {
        $query .= " AND t.created_at <= :end_date";
        $params[':end_date'] = $end_date . ' 23:59:59';
    }

    $query .= " ORDER BY t.created_at DESC";
    $query .= " LIMIT 200";

    $stmt = $db->prepare($query);
    $stmt->execute($params);
    $transactions = $stmt->fetchAll(PDO::FETCH_ASSOC);

} catch (PDOException $e) {
    error_log("BTC Transactions DB Error: " . $e->getMessage());
    $transactions = [];
    $pageError = "Could not load BTC transaction data.";
}

include 'includes/header.php';
?>

<div class="container-fluid">
    <!-- *** MODIFICATION: Updated Title *** -->
    <h1 class="h3 mb-4 text-gray-800">BTC Transactions</h1>

    <div class="card shadow mb-4">
        <div class="card-header py-3">
            <h6 class="m-0 font-weight-bold text-primary">Filter BTC Transactions</h6>
        </div>
        <div class="card-body">
            <!-- *** MODIFICATION: Updated form action *** -->
            <form method="GET" action="btc_transactions.php">
                <div class="row align-items-end g-3">
                    <div class="col-md-4">
                        <label for="start_date" class="form-label">Start Date</label>
                        <input type="date" class="form-control" id="start_date" name="start_date" value="<?php echo htmlspecialchars($start_date); ?>">
                    </div>
                    <div class="col-md-4">
                        <label for="end_date" class="form-label">End Date</label>
                        <input type="date" class="form-control" id="end_date" name="end_date" value="<?php echo htmlspecialchars($end_date); ?>">
                    </div>
                    <div class="col-md-4">
                        <button type="submit" class="btn btn-primary">Apply Filter</button>
                        <!-- *** MODIFICATION: Updated reset link *** -->
                        <a href="btc_transactions.php" class="btn btn-secondary">Reset</a>
                    </div>
                </div>
            </form>
        </div>
    </div>

    <div class="card shadow mb-4">
        <div class="card-body">
            <div class="table-responsive">
                <table class="table table-bordered table-hover" width="100%">
                    <thead class="table-light">
                        <tr>
                            <th>Date</th>
                            <th>User</th>
                            <th>Description</th>
                            <th>Type</th>
                            <th>Amount</th>
                            <th>Status</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php if (empty($transactions)): ?>
                            <!-- *** MODIFICATION: Updated empty message *** -->
                            <tr><td colspan="6" class="text-center text-muted py-4">No BTC transactions found for the selected criteria.</td></tr>
                        <?php else: ?>
                            <?php foreach ($transactions as $tx): ?>
                                <tr>
                                    <td><?php echo date('d M Y, H:i', strtotime($tx['created_at'])); ?></td>
                                    <td><?php echo htmlspecialchars($tx['first_name'] . ' ' . $tx['last_name']); ?></td>
                                    <td><?php echo htmlspecialchars($tx['description']); ?></td>
                                    <td>
                                        <span class="badge text-bg-<?php echo $tx['type'] == 'credit' ? 'success' : 'danger'; ?>"><?php echo ucfirst($tx['type']); ?></span>
                                    </td>
                                    <td class="fw-bold <?php echo $tx['type'] == 'credit' ? 'text-success' : 'text-danger'; ?>">
                                        <?php echo htmlspecialchars($tx['currency']); ?> <?php echo number_format($tx['amount'], 8); // Show more decimals for BTC ?>
                                    </td>
                                    <td>
                                        <span class="badge rounded-pill text-bg-<?php echo $tx['status'] == 'completed' ? 'success' : 'warning'; ?>">
                                            <?php echo ucfirst($tx['status']); ?>
                                        </span>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
