<?php
// EmailService.php

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';

class EmailService {
    private $mailer;

    public function __construct() {
        $this->mailer = new PHPMailer(true);
        
        // Configure mail settings
        $this->mailer->isSMTP();
        $this->mailer->Host = $_ENV['SMTP_HOST'];
        $this->mailer->SMTPAuth = true;
        $this->mailer->Username = $_ENV['SMTP_USERNAME'];
        $this->mailer->Password = $_ENV['SMTP_PASSWORD'];
        $this->mailer->SMTPSecure = PHPMailer::ENCRYPTION_STARTTLS;
        $this->mailer->Port = $_ENV['SMTP_PORT'];
        
        $this->mailer->setFrom($_ENV['MAIL_FROM_ADDRESS'], $_ENV['MAIL_FROM_NAME']);
    }

    public function sendWelcomeEmail($to, $data) {
        try {
            $this->mailer->addAddress($to);
            $this->mailer->isHTML(true);
            $this->mailer->Subject = 'Welcome to First National Bank Incorporated - Account Created Successfully';
            
            // Email template
            $body = $this->getWelcomeEmailTemplate($data);
            
            $this->mailer->Body = $body;
            $this->mailer->send();
            
            return true;
        } catch (Exception $e) {
            error_log("Email sending failed: " . $e->getMessage());
            return false;
        }
    }

    public function sendVerificationEmail($to, $token) {
        try {
            $this->mailer->addAddress($to);
            $this->mailer->isHTML(true);
            $this->mailer->Subject = 'Verify Your Email Address';
            
            $verificationLink = $_ENV['APP_URL'] . '/verify-email.php?token=' . $token;
            
            $body = $this->getVerificationEmailTemplate($verificationLink);
            
            $this->mailer->Body = $body;
            $this->mailer->send();
            
            return true;
        } catch (Exception $e) {
            error_log("Email sending failed: " . $e->getMessage());
            return false;
        }
    }

    private function getWelcomeEmailTemplate($data) {
        return '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #2563eb; color: white; padding: 20px; text-align: center; border-radius: 10px 10px 0 0; }
                .content { background: #fff; padding: 20px; border-radius: 0 0 10px 10px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
                .button { display: inline-block; padding: 10px 20px; background: #2563eb; color: white; text-decoration: none; border-radius: 5px; }
                .security-code { background: #f8fafc; padding: 10px; border-radius: 5px; margin: 10px 0; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>Welcome to First National Bank Incorporated!</h1>
                </div>
                <div class="content">
                    <h2>Hello ' . htmlspecialchars($data['firstName']) . ',</h2>
                    <p>Thank you for creating an account with us. Your account has been successfully created!</p>
                    
                    <h3>Your Account Details:</h3>
                    <p><strong>Account Number:</strong> ' . htmlspecialchars($data['accountNumber']) . '</p>
                    
                    <div class="security-code">
                        <h4>Your Security Codes:</h4>
                        <p><strong>COT Code:</strong> ' . htmlspecialchars($data['securityCodes']['cot']) . '</p>
                        <p><strong>IMF Code:</strong> ' . htmlspecialchars($data['securityCodes']['imf']) . '</p>
                        <p><strong>TAX Code:</strong> ' . htmlspecialchars($data['securityCodes']['tax']) . '</p>
                    </div>
                    
                    <p><strong>Important:</strong> Please keep these codes safe and never share them with anyone.</p>
                    
                    <p>To start using your account, please click the button below to verify your email address:</p>
                    
                    <p style="text-align: center;">
                        <a href="[Verification_Link]" class="button">Verify Email Address</a>
                    </p>
                    
                    <p>If you have any questions or need assistance, please don\'t hesitate to contact our support team.</p>
                    
                    <p>Best regards,<br>First National Bank Incorporated Team</p>
                </div>
            </div>
        <!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/698919832510d91c3c5b9ece/1jgvonb1o';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
</body>
        </html>';
    }

    private function getVerificationEmailTemplate($verificationLink) {
        return '
        <!DOCTYPE html>
        <html>
        <head>
            <style>
                body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
                .container { max-width: 600px; margin: 0 auto; padding: 20px; }
                .header { background: #2563eb; color: white; padding: 20px; text-align: center; border-radius: 10px 10px 0 0; }
                .content { background: #fff; padding: 20px; border-radius: 0 0 10px 10px; box-shadow: 0 2px 5px rgba(0,0,0,0.1); }
                .button { display: inline-block; padding: 10px 20px; background: #2563eb; color: white; text-decoration: none; border-radius: 5px; }
            </style>
        </head>
        <body>
            <div class="container">
                <div class="header">
                    <h1>Verify Your Email Address</h1>
                </div>
                <div class="content">
                    <p>Please click the button below to verify your email address:</p>
                    
                    <p style="text-align: center;">
                        <a href="' . $verificationLink . '" class="button">Verify Email Address</a>
                    </p>
                    
                    <p>If you did not create an account, no further action is required.</p>
                    
                    <p>Best regards,<br>First National Bank Incorporated Team</p>
                </div>
            </div>
        <!--Start of Tawk.to Script-->
<script type="text/javascript">
var Tawk_API=Tawk_API||{}, Tawk_LoadStart=new Date();
(function(){
var s1=document.createElement("script"),s0=document.getElementsByTagName("script")[0];
s1.async=true;
s1.src='https://embed.tawk.to/698919832510d91c3c5b9ece/1jgvonb1o';
s1.charset='UTF-8';
s1.setAttribute('crossorigin','*');
s0.parentNode.insertBefore(s1,s0);
})();
</script>
<!--End of Tawk.to Script-->
</body>
        </html>';
    }
}
